/* Automatically generated by './algorithms.pl' from the list of algorithms
 * in 'algorithms.txt'.
 */

static int algowrap_adler32 (lua_State *L);
static int algowrap_base64_decode (lua_State *L);
static int algowrap_base64_encode (lua_State *L);
static int algowrap_hex_decode (lua_State *L);
static int algowrap_hex_lower (lua_State *L);
static int algowrap_hex_upper (lua_State *L);
static int algowrap_md5 (lua_State *L);
static int algowrap_percent_decode (lua_State *L);
static int algowrap_percent_encode (lua_State *L);
static int algowrap_qp_decode (lua_State *L);
static int algowrap_qp_encode (lua_State *L);
static int algowrap_sha1 (lua_State *L);

static const AlgorithmDefinition
filter_algorithms[] = {
    { "adler32", algo_adler32, algowrap_adler32,
      sizeof(Adler32State), algo_adler32_init, 0 },
    { "base64_decode", algo_base64_decode, algowrap_base64_decode,
      sizeof(Base64DecodeState), algo_base64_decode_init, 0 },
    { "base64_encode", algo_base64_encode, algowrap_base64_encode,
      sizeof(Base64EncodeState), algo_base64_encode_init, algo_base64_encode_destroy },
    { "hex_decode", algo_hex_decode, algowrap_hex_decode,
      sizeof(HexDecodeState), algo_hex_decode_init, 0 },
    { "hex_lower", algo_hex_lower, algowrap_hex_lower,
      0, 0, 0 },
    { "hex_upper", algo_hex_upper, algowrap_hex_upper,
      0, 0, 0 },
    { "md5", algo_md5, algowrap_md5,
      sizeof(MD5State), algo_md5_init, 0 },
    { "percent_decode", algo_percent_decode, algowrap_percent_decode,
      0, 0, 0 },
    { "percent_encode", algo_percent_encode, algowrap_percent_encode,
      sizeof(PercentEncodeState), algo_percent_encode_init, 0 },
    { "qp_decode", algo_qp_decode, algowrap_qp_decode,
      0, 0, 0 },
    { "qp_encode", algo_qp_encode, algowrap_qp_encode,
      sizeof(QPEncodeState), algo_qp_encode_init, algo_qp_encode_destroy },
    { "sha1", algo_sha1, algowrap_sha1,
      sizeof(SHA1State), algo_sha1_init, 0 },
};
#define NUM_ALGO_DEFS (sizeof(filter_algorithms) / sizeof(AlgorithmDefinition))

static int algowrap_adler32 (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[0]);
}
static int algowrap_base64_decode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[1]);
}
static int algowrap_base64_encode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[2]);
}
static int algowrap_hex_decode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[3]);
}
static int algowrap_hex_lower (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[4]);
}
static int algowrap_hex_upper (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[5]);
}
static int algowrap_md5 (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[6]);
}
static int algowrap_percent_decode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[7]);
}
static int algowrap_percent_encode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[8]);
}
static int algowrap_qp_decode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[9]);
}
static int algowrap_qp_encode (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[10]);
}
static int algowrap_sha1 (lua_State *L) {
    return algo_wrapper(L, &filter_algorithms[11]);
}
